<?php
/**
 * Represents the view for the administration dashboard.
 *
 * This includes the header, options, and other information that should provide
 * The User Interface to the end user.
 *
 * @package   Hello2Forms
 * @author    Infinite Consultancy LTD <contact@hello2.com>
 * @copyright 2024 Infinite Consultancy LTD
 * @license   GPL 2.0+
 * @link      https://hello2.com
 */

use Hello2Forms\Internals\Vite;

?>
<script>
	window.config = {
		"VITE_VAPOR_ASSET_URL": "<?php echo esc_js(get_option( 'hello2forms_settings' )['VITE_VAPOR_ASSET_URL'] ?? ''); ?>",
		"app_name": "<?php echo esc_js(get_option( 'hello2forms_settings' )['app_name'] ?? ''); ?>",
		"locale": "en",
		"locales": {"en": "EN"},
		"hCaptchaSiteKey":  "<?php echo esc_js(get_option( 'hello2forms_settings' )['hCaptchaSiteKey'] ?? ''); ?>",
		"notion": {"worker": ""},
		"nonce": "<?php echo esc_js(wp_create_nonce( 'wp_rest' )); ?>",
		"wordpress_location": "<?php echo esc_js(site_url()); ?>",
		"is_logged_in": "<?php echo esc_js(is_user_logged_in()); ?>",
		"integrations": {
			"google" : {
				"calendar": {
					"client_id": "<?php echo esc_js(get_option( 'hello2forms_settings' )['google_calendar_api_client_id'] ?? ''); ?>",
					"client_secret": "<?php echo esc_js(get_option( 'hello2forms_settings' )['google_calendar_api_secret'] ?? ''); ?>"
				}
			}
		}
	}
</script>
<div class="wrap">
	<div id="app">
		Vue mounts here.
	</div>
	<?php
	try {
		$vite= new Vite();
		$vite->outDir(dirname(HF_PLUGIN_ABSOLUTE).'/assets/client/');
		$vite->entry('src/app.js');
		
		echo wp_kses($vite->__toString(), [
		    'script' => [
		        'type' => [],
		        'crossorigin' => [],
		        'src' => []
		        ],
		    'link' => [
		        'href' => [],
		        'rel' => []
		        ],
		]);
	} catch ( Exception $e ) {
		if ( WP_DEBUG ) {
		    echo esc_html($e->getMessage());
		}
		esc_html_e( 'Could not render frontend, please contact support. ', HF_TEXTDOMAIN );
	}
	?>
</div>

