<?php

namespace Hello2Forms\Service\Actions;

use Hello2Forms\Architecture\Action;

class WebhookAction implements Action {

	public function run(array $form, array $action, array $submittedData): void {
		$this->runWebhook($action['data']['url'], $form);
	}

	public function runWebhook(string $url, array $data): void {
		// Initialize cURL session
		$ch = curl_init($url);

		// Set cURL options
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return the response as a string instead of outputting it directly
		curl_setopt($ch, CURLOPT_POST, true); // Set the request method to POST
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data); // Set the POST data

		// Execute the request and get the response
		curl_exec($ch);

		// Check for errors
        if (curl_errno($ch)) {
            echo 'Error: ' . esc_html(curl_error($ch));
        }

		// Close cURL session
		curl_close($ch);

	}
}
