<?php

namespace Hello2Forms\Service;

use Hello2Forms\Architecture\ValidatorRule;
use Illuminate\Container\Container;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Translation\FileLoader;
use Illuminate\Translation\Translator;
use Illuminate\Validation\Factory;

class DataValidatorService {
	public function validate( array $data, ValidatorRule $validatorRules ): array {
		$validatorRules->setFormData($data);
		$translationDir = HF_PLUGIN_ROOT . '/languages/';
		$filesystem = new Filesystem();
		$fileLoader = new FileLoader($filesystem, '');
		$translator = new Translator($fileLoader, 'en_US');
		$factory = new Factory($translator,new Container());
		$fileLoader = new FileLoader($filesystem, $translationDir);
		$fileLoader->addNamespace('lang', $translationDir);
		$fileLoader->load('en', 'validation', 'lang');

		$validator = $factory->make($data, $validatorRules->rules(), $validatorRules->messages());

		if ( $validator->fails() ) {
			return $validator->errors()->toArray();
		}

		return [];
	}
}
