<?php

namespace Hello2Forms\Repository;

use Hello2Forms\Architecture\Repository;
use Hello2Forms\Casts\FormDataCast;
use Hello2Forms\Internals\CastHelper;

class WorkspaceRepository extends Repository {
	function isPro( int $workspace ): bool {
		return count( $this->getResults( 'SELECT * FROM wp_hello2_forms_workspaces WHERE id = ' . $workspace ) ) > 0;
	}

	function findAll() {
		$result = $this->getResults( 'SELECT id FROM wp_hello2_forms_workspaces' );

		foreach ( $result as $key => $val ) {
			$result[ $key ] = $this->findOneById($val['id']);
		}

		return $result;
	}

	function findOneById( int $id ) {
		$result = $this->getResults( 'SELECT * FROM wp_hello2_forms_workspaces WHERE id = ' . $id );

		if ( count( $result ) === 0 ) {
			return null;
		}

		$result = $result[0];

		$relation = $this->getResults( 'SELECT * FROM wp_hello2_forms_user_workspace WHERE workspace_id = ' . $result['id'] );

		$owners = [];

		foreach ( $relation as $relationVal ) {
			$owners[] = $this->eagerLoadUser( $relationVal['user_id'] );
		}
		return [
			...$result,
			'owners'        => $owners,
			'is_enterprise' => false,
			'is_pro'        => false,
			'pivot'         => $relation
		];
	}

	protected function eagerLoadUser( int $userId ) {
		$userRepository = new UserRepository();

		return $userRepository->findById( $userId );
	}

	function store(
		string $name,
		string $icon,
		int $userId
	): bool {
		$time = date("Y-m-d h:i:s");

		$this->insert( 'wp_hello2_forms_workspaces',
			[
				'created_at' => $time,
				'updated_at' => $time,
				'name'       => $name,
				'icon'       => $icon
			]
		);

		$this->insert( 'wp_hello2_forms_user_workspace',
			[
				'workspace_id' => $this->db->insert_id,
				'user_id' => $userId,
				'created_at' => $time,
				'updated_at' => $time,
				'role' => 'admin'
			]
		);

		return false;
	}

	function isUserInWorkspace( int $userId, int $workspaceId ) {
		return $this->getResults( 'SELECT * FROM wp_hello2_forms_user_workspace WHERE workspace_id = ' . $workspaceId. ' AND user_id = '.$userId )[0];
	}

	function findFormsByWorkspaceId( int $workspaceId ) {
		return $this->getResults( 'SELECT * FROM wp_hello2_forms_forms WHERE workspace_id = ' . $workspaceId );
	}

	function delete(int $workspaceId) {
		return $this->db->delete( $this->realTable('wp_hello2_forms_workspaces'), [
			"id" => $workspaceId
		] );
	}

	function findCurrentUserForms( int $workspaceId ) {
		$finalResults = [];
		$result       = $this->getResults( 'SELECT * FROM wp_hello2_forms_forms WHERE workspace_id = ' . $workspaceId . ' AND creator_id = ' . get_current_user_id() . ' ORDER BY updated_at DESC' );
		$submissionRepository = new FormSubmissionsRepository();
		$formRepository = new FormRepository();
		foreach ( $result as $val ) {

			$links = ( new ActionRepository() )->findLinksForForm( $val['id'] );

			$actions = [];

			foreach ( $links as $link ) {
				$actions[] = ( new ActionRepository() )->findOneBy( 'id', $link['action_id'] );
			}

			$finalResults[] = [
				...CastHelper::cast(FormDataCast::class, $val),
				'actions' => $actions,
				'creator'           => [ ...$this->eagerLoadUser( get_current_user_id() ), ],
				'share_url'         => get_site_url() . '/form/#/forms/' . $val['slug'],
				'views_count'       => $formRepository->countFormViews($val['id']),
				'submissions'       => [],
				'submissions_count' => $submissionRepository->countSubmissionsForForm($val['id']),
				'last_edited_human' => human_time_diff(strtotime($val['updated_at'])). ' ago',
				'extra'             => [
					"loadedWorkspace" => $this->findOneById( $workspaceId ),
					"workspaceIsPro"  => false,
					"userIsOwner"     => true,
					"cleanings"       => []
				]
			];
		}

		return $finalResults;
	}

	public function findByUserId( $ID ): ?array {
		$result = $this->getResults( 'SELECT * FROM wp_hello2_forms_user_workspace WHERE user_id = ' . $ID );

		if ( count( $result ) === 0 ) {
			return null;
		}

		$workspaces = [];

		foreach ( $result as $val ) {
			$workspaces[] = $this->findOneById( $val['workspace_id'] );
		}

		return $workspaces;
	}
}
