<?php

namespace Hello2Forms\Repository;

use Hello2Forms\Architecture\Repository;

final class MigrationRepository extends Repository {
	public function findAll(): array {
		return $this->db->get_results( $this->realTable( "SELECT * FROM wp_hello2_forms_migrations" ), ARRAY_A );
	}

	public function persist( string $class, int $timestamp ): void {
		$this->db->insert(
			$this->realTable( 'wp_hello2_forms_migrations' ),
			[
				'class'     => $class,
				'timestamp' => $timestamp,
				'run_date'  => time()
			]
		);
	}

	public function removeBy( string $by, int $value ): void {
		$this->db->delete(
			$this->realTable( 'wp_hello2_forms_migrations' ),
			[ $by => $value ]
		);
	}
}
