<?php

namespace Hello2Forms\Repository;

use Hello2Forms\Architecture\Repository;
use Hello2Forms\Casts\FormDataCast;
use Hello2Forms\Casts\IntegrationAccountCast;
use Hello2Forms\Internals\CastHelper;

class IntegrationAccountsRepository extends Repository {

	function store(
		string $name,
		string $type,
		array $data,
		int $userId
	): bool {
		$time = date("Y-m-d h:i:s");

		$this->insert( 'wp_hello2_forms_integrations_accounts',
			[
				'created_at' => $time,
				'updated_at' => $time,
				'name'       => $name,
				'type'       => $type,
				'data'       => json_encode( $data ),
				'user_id'    => $userId
			]
		);

		return false;
	}

	function findBy( string $column, $value ): ?array {
		$result = $this->getResults( 'SELECT * FROM wp_hello2_forms_integrations_accounts WHERE ' . $column . ' = "' . $value . '"' );
		return CastHelper::castArray(IntegrationAccountCast::class,$result) ?? null;
	}

	function findByUserIdAndType($id, string $type ): ?array {
		$result = $this->getResults( "SELECT * FROM wp_hello2_forms_integrations_accounts WHERE user_id = $id AND type = '$type'");
		return CastHelper::castArray(IntegrationAccountCast::class,$result) ?? null;
	}

	function findByIdAndType($id, string $type ): ?array {
		$result = $this->getResults( "SELECT * FROM wp_hello2_forms_integrations_accounts WHERE id = $id AND type = '$type'");
		return CastHelper::castArray(IntegrationAccountCast::class,$result) ?? null;
	}
}
