<?php

namespace Hello2Forms\Repository;

use Hello2Forms\Architecture\Repository;
use Hello2Forms\Casts\SubmissionDataCast;
use Hello2Forms\Internals\CastHelper;

class FormSubmissionsRepository extends Repository {
	function store( array $data ): int {
		$this->db->insert(
			$this->realTable( 'wp_hello2_forms_form_submissions' ),
			$data
		);

		return $this->db->insert_id;
	}

	function update( array $data, array $where ): int {
		$this->db->update(
			$this->realTable( 'wp_hello2_forms_form_submissions' ),
			$data,
			$where
		);

		return $this->db->insert_id;
	}

	function findOneById( int $id ) {
		$result = $this->getResults('SELECT * FROM wp_hello2_forms_form_submissions WHERE id = ' . $id);
		return CastHelper::cast(SubmissionDataCast::class,$result[0]) ?? null;
	}

	public function countSubmissionsForForm( int $id ) {
		$result = $this->getResults('SELECT COUNT(id) FROM wp_hello2_forms_form_submissions WHERE form_id = ' . $id);

		return $result[0]['COUNT(id)'];
	}
}
