<?php

namespace Hello2Forms\Repository;

use Hello2Forms\Architecture\Repository;
use Hello2Forms\Casts\FormDataCast;
use Hello2Forms\Casts\SubmissionDataCast;
use Hello2Forms\Internals\CastHelper;

class FormRepository extends Repository {

	function findOneBy( $column, $value ): ?array {
		$result = $this->getResults( 'SELECT * FROM wp_hello2_forms_forms WHERE ' . $column . ' = "' . $value . '"' );

		$result[0]['actions'] = ( new ActionRepository() )->findLinksForForm( $result[0]['id'] );

		return $result ? CastHelper::cast( FormDataCast::class, $result[0] ) : null;
	}

	function findSubmission( int $submissionId, int $formId ): ?array {
		$result = $this->getResults( 'SELECT * FROM wp_hello2_forms_form_submissions WHERE form_id = ' . $formId . ' AND id = ' . $submissionId );

		return CastHelper::cast( SubmissionDataCast::class, $result[0] ) ?? null;
	}

	function findAllSubmissions( int $formId ): ?array {
		$result = $this->getResults( 'SELECT * FROM wp_hello2_forms_form_submissions WHERE form_id = ' . $formId );

		return CastHelper::castArray( SubmissionDataCast::class, $result ) ?? null;
	}

	function countAllSubmissions(): int {
		$result = $this->getResults( 'SELECT COUNT(id) FROM wp_hello2_forms_form_submissions' );

		return $result[0]['COUNT(*)'];
	}

	function countSubmissions( int $formId ): int {
		$result = $this->getResults( 'SELECT COUNT(*) FROM wp_hello2_forms_form_submissions WHERE form_id = ' . $formId );

		return $result[0]['COUNT(*)'];
	}

	function delete( int $id ) {
		return $this->db->delete( 'wp_hello2_forms_forms', [ 'id' => $id ] );
	}

	function duplicate( int $id ) {
		$result = $this->getResults( 'SELECT * FROM wp_hello2_forms_forms WHERE id = ' . $id );

		if ( count( $result ) === 0 ) {
			return null;
		}
		$result = $result[0];

		return $this->insert( 'wp_hello2_forms_forms', [ ...$result, 'id' => null ] );
	}

	function store(
		array $data,
		int $creator_id
	): bool {
		$firstInsert      = $this->insert( 'wp_hello2_forms_forms',
			CastHelper::cast( FormDataCast::class, [
				...$data,
				'created_at' => date( "Y-m-d h:i:s" ),
				'updated_at' => date( "Y-m-d h:i:s" ),
				'slug'       => sanitize_title( $data['title'], esc_html__( 'Could not safely sanitize title!', HF_TEXTDOMAIN ) ),
				'creator_id' => $creator_id
			], true ),
		);
		$actionRepository = new ActionRepository();

		foreach ( $data['actions'] as $action ) {
			if ( $actionRepository->findLink( $action['id'], $data['id'] ) === null ) {
				$actionRepository->link( $action['id'], $data['id'], $action['order'] );
			}
		}

		return $firstInsert;
	}

	function countFormViews( int $form_id ) {
		$result = $this->getResults( 'SELECT COUNT(id) FROM wp_hello2_forms_form_views WHERE form_id = ' . $form_id );

		return $result[0]['COUNT(id)'];
	}

	function update(
		array $data,
		array $where
	): bool {
		$actionRepository = new ActionRepository();

		foreach ( $data['actions'] as $key => $action ) {
			if ( count( $actionRepository->findLink( $action['id'], $data['id'] ) ) === 0 ) {
				$actionRepository->link( $action['id'], $data['id'], $key );
			}
		}

		$links = $actionRepository->findLinksForForm( $data['id'] );

		if ( count( $links ) > 0 ) {
			// Delete all links that are not in the new data
			foreach ( $links as $link ) {
				$found = false;
				foreach ( $data['actions'] as $action ) {
					if ( $action['id'] == $link['action_id'] ) {
						$found = true;
						break;
					}
				}
				if ( ! $found ) {
					$actionRepository->deleteLink( $link['id'] );
				}
			}
		}

		return ! is_null( $this->db->update( 'wp_hello2_forms_forms',
			CastHelper::cast( FormDataCast::class, [
				...$data,
				'created_at' => date( "Y-m-d h:i:s" ),
				'updated_at' => date( "Y-m-d h:i:s" ),
			], true ),
			$where
		) );
	}

	public function deleteRecord( int $id, int $recordId ) {
		return $this->db->delete( 'wp_hello2_forms_form_submissions', [ 'id' => $recordId ] );
	}
}
