<?php

namespace Hello2Forms\Repository;

use Hello2Forms\Architecture\Integration;
use Hello2Forms\Architecture\Repository;
use Hello2Forms\Casts\ActionDataCast;
use Hello2Forms\Internals\CastHelper;

class ActionRepository extends Repository {
	function findOneBy( $column, $value ): ?array {
		$result = $this->getResults( 'SELECT * FROM wp_hello2_forms_actions WHERE ' . $column . ' = "' . $value . '"' );
		return CastHelper::cast(ActionDataCast::class,$result[0]) ?? null;
	}

	function findAll( ): ?array {
		$result = $this->getResults( 'SELECT * FROM wp_hello2_forms_actions' );
		return CastHelper::castArray(ActionDataCast::class,$result) ?? null;
	}

	function store(
		array $data,
		int $creator_id
	) {

		return $this->insert( 'wp_hello2_forms_actions',
			CastHelper::cast( ActionDataCast::class, [
				...$data,
				'created_at' => date( "Y-m-d h:i:s" ),
				'updated_at' => date( "Y-m-d h:i:s" ),
				'user_id' => $creator_id
			], true ),
		);
	}

	function link(int $action_id, int $form_id, int $key) {
		return $this->insert( 'wp_hello2_forms_form_actions', [
				'form_id'    => $form_id,
				'action_id'  => $action_id,
				'order'      => $key,
				'updated_at' => date( "Y-m-d h:i:s" ),
				'created_at' => date( "Y-m-d h:i:s" ),
			]
		);
	}

	function findLink(int $action_id, int $form_id) {
		return $this->getResults( 'SELECT * FROM wp_hello2_forms_form_actions WHERE form_id = ' . $form_id . ' AND action_id = ' . $action_id);
	}

	function findLinksForForm(int $form_id) {
		return $this->getResults( 'SELECT * FROM wp_hello2_forms_form_actions WHERE form_id = ' . $form_id . ' ORDER BY `order` ASC');
	}

	function findAllActionsForForm( int $form_id ): ?array {
		$result = $this->getResults( 'SELECT * FROM wp_hello2_forms_form_actions WHERE form_id = ' . $form_id . ' ORDER BY `order` ASC' );

		$actions = array_map( function ( $link ) {
			return $link['action_id'];
		}, $result );

		if ( empty( $actions ) ) {
			return null;
		}

		$result = $this->getResults( 'SELECT * FROM wp_hello2_forms_actions WHERE id IN (' . implode( ',', $actions ) . ')');

		$result = CastHelper::castArray(ActionDataCast::class,$result) ?? null;

		if ($result === null) {
			return null;
		}

		foreach ($result as $key => $value) {
			if (isset( $value['data']['account'])) {
				$result[$key]['data']['account'] = $this->getResults( 'SELECT * FROM wp_hello2_forms_integrations_accounts WHERE id = ' . $value['data']['account'])[0];
				$result[$key]['data']['account']['data'] = json_decode($result[$key]['data']['account']['data'], true);
			}
		}

		return $result;
	}

	function update(
		array $data,
		array $where
	): bool {
		return ! is_null( $this->db->update( 'wp_hello2_forms_actions',
			CastHelper::cast( ActionDataCast::class, [
				'data' => $data['data'],
				'updated_at' => date( "Y-m-d h:i:s" ),
			], true ),
			$where
		) );
	}
	function deleteLink(int $linkId) {
		return $this->db->delete( $this->realTable('wp_hello2_forms_form_actions'), [
			"id" => $linkId
		] );
	}
	function delete(int $actionId) {
		return $this->db->delete( $this->realTable('wp_hello2_forms_actions'), [
			"id" => $actionId
		] );
	}
}
