<?php

return [

	/*
	|--------------------------------------------------------------------------
	| Validation Language Lines
	|--------------------------------------------------------------------------
	|
	| The following language lines contain the default error messages used by
	| the validator class. Some of these rules have multiple versions such
	| as the size rules. Feel free to tweak each of these messages here.
	|
	*/

	'accepted' => esc_html__('The :attribute must be accepted.', HF_TEXTDOMAIN),
	'accepted_if' => esc_html__('The :attribute must be accepted when :other is :value.', HF_TEXTDOMAIN),
	'active_url' => esc_html__('The :attribute is not a valid URL.', HF_TEXTDOMAIN),
	'after' => esc_html__('The :attribute must be a date after :date.', HF_TEXTDOMAIN),
	'after_or_equal' => esc_html__('The :attribute must be a date after or equal to :date.', HF_TEXTDOMAIN),
	'alpha' => esc_html__('The :attribute must only contain letters.', HF_TEXTDOMAIN),
	'alpha_dash' => esc_html__('The :attribute must only contain letters, numbers, dashes and underscores.', HF_TEXTDOMAIN),
	'alpha_num' => esc_html__('The :attribute must only contain letters and numbers.', HF_TEXTDOMAIN),
	'array' => esc_html__('The :attribute must be an array.', HF_TEXTDOMAIN),
	'before' => esc_html__('The :attribute must be a date before :date.', HF_TEXTDOMAIN),
	'before_or_equal' => esc_html__('The :attribute must be a date before or equal to :date.', HF_TEXTDOMAIN),
	'between' => [
		'numeric' => esc_html__('The :attribute must be between :min and :max.', HF_TEXTDOMAIN),
		'file' => esc_html__('The :attribute must be between :min and :max kilobytes.', HF_TEXTDOMAIN),
		'string' => esc_html__('The :attribute must be between :min and :max characters.', HF_TEXTDOMAIN),
		'array' => esc_html__('The :attribute must have between :min and :max items.', HF_TEXTDOMAIN),
	],
	'boolean' => esc_html__('The :attribute field must be true or false.', HF_TEXTDOMAIN),
	'confirmed' => esc_html__('The :attribute confirmation does not match.', HF_TEXTDOMAIN),
	'current_password' => esc_html__('The password is incorrect.', HF_TEXTDOMAIN),
	'date' => esc_html__('The :attribute is not a valid date.', HF_TEXTDOMAIN),
	'date_equals' => esc_html__('The :attribute must be a date equal to :date.', HF_TEXTDOMAIN),
	'date_format' => esc_html__('The :attribute does not match the format :format.', HF_TEXTDOMAIN),
	'declined' => esc_html__('The :attribute must be declined.', HF_TEXTDOMAIN),
	'declined_if' => esc_html__('The :attribute must be declined when :other is :value.', HF_TEXTDOMAIN),
	'different' => esc_html__('The :attribute and :other must be different.', HF_TEXTDOMAIN),
	'digits' => esc_html__('The :attribute must be :digits digits.', HF_TEXTDOMAIN),
	'digits_between' => esc_html__('The :attribute must be between :min and :max digits.', HF_TEXTDOMAIN),
	'dimensions' => esc_html__('The :attribute has invalid image dimensions.', HF_TEXTDOMAIN),
	'distinct' => esc_html__('The :attribute field has a duplicate value.', HF_TEXTDOMAIN),
	'email' => esc_html__('The :attribute must be a valid email address.', HF_TEXTDOMAIN),
	'ends_with' => esc_html__('The :attribute must end with one of the following: :values.', HF_TEXTDOMAIN),
	'enum' => esc_html__('The selected :attribute is invalid.', HF_TEXTDOMAIN),
	'exists' => esc_html__('The selected :attribute is invalid.', HF_TEXTDOMAIN),
	'file' => esc_html__('The :attribute must be a file.', HF_TEXTDOMAIN),
	'filled' => esc_html__('The :attribute field must have a value.', HF_TEXTDOMAIN),
	'gt' => [
		'numeric' => esc_html__('The :attribute must be greater than :value.', HF_TEXTDOMAIN),
		'file' => esc_html__('The :attribute must be greater than :value kilobytes.', HF_TEXTDOMAIN),
		'string' => esc_html__('The :attribute must be greater than :value characters.', HF_TEXTDOMAIN),
		'array' => esc_html__('The :attribute must have more than :value items.', HF_TEXTDOMAIN),
	],
	'gte' => [
		'numeric' => esc_html__('The :attribute must be greater than or equal to :value.', HF_TEXTDOMAIN),
		'file' => esc_html__('The :attribute must be greater than or equal to :value kilobytes.', HF_TEXTDOMAIN),
		'string' => esc_html__('The :attribute must be greater than or equal to :value characters.', HF_TEXTDOMAIN),
		'array' => esc_html__('The :attribute must have :value items or more.', HF_TEXTDOMAIN),
	],
	'image' => esc_html__('The :attribute must be an image.', HF_TEXTDOMAIN),
	'in' => esc_html__('The selected :attribute is invalid.', HF_TEXTDOMAIN),
	'in_array' => esc_html__('The :attribute field does not exist in :other.', HF_TEXTDOMAIN),
	'integer' => esc_html__('The :attribute must be an integer.', HF_TEXTDOMAIN),
	'ip' => esc_html__('The :attribute must be a valid IP address.', HF_TEXTDOMAIN),
	'ipv4' => esc_html__('The :attribute must be a valid IPv4 address.', HF_TEXTDOMAIN),
	'ipv6' => esc_html__('The :attribute must be a valid IPv6 address.', HF_TEXTDOMAIN),
	'json' => esc_html__('The :attribute must be a valid JSON string.', HF_TEXTDOMAIN),
	'lt' => [
		'numeric' => esc_html__('The :attribute must be less than :value.', HF_TEXTDOMAIN),
		'file' => esc_html__('The :attribute must be less than :value kilobytes.', HF_TEXTDOMAIN),
		'string' => esc_html__('The :attribute must be less than :value characters.', HF_TEXTDOMAIN),
		'array' => esc_html__('The :attribute must have less than :value items.', HF_TEXTDOMAIN),
	],
	'lte' => [
		'numeric' => esc_html__('The :attribute must be less than or equal to :value.', HF_TEXTDOMAIN),
		'file' => esc_html__('The :attribute must be less than or equal to :value kilobytes.', HF_TEXTDOMAIN),
		'string' => esc_html__('The :attribute must be less than or equal to :value characters.', HF_TEXTDOMAIN),
		'array' => esc_html__('The :attribute must not have more than :value items.', HF_TEXTDOMAIN),
	],
	'mac_address' => esc_html__('The :attribute must be a valid MAC address.', HF_TEXTDOMAIN),
	'max' => [
		'numeric' => esc_html__('The :attribute must not be greater than :max.', HF_TEXTDOMAIN),
		'file' => esc_html__('The :attribute must not be greater than :max kilobytes.', HF_TEXTDOMAIN),
		'string' => esc_html__('The :attribute must not be greater than :max characters.', HF_TEXTDOMAIN),
		'array' => esc_html__('The :attribute must not have more than :max items.', HF_TEXTDOMAIN),
	],
	'mimes' => esc_html__('The :attribute must be a file of type: :values.', HF_TEXTDOMAIN),
	'mimetypes' => esc_html__('The :attribute must be a file of type: :values.', HF_TEXTDOMAIN),
	'min' => [
		'numeric' => esc_html__('The :attribute must be at least :min.', HF_TEXTDOMAIN),
		'file' => esc_html__('The :attribute must be at least :min kilobytes.', HF_TEXTDOMAIN),
		'string' => esc_html__('The :attribute must be at least :min characters.', HF_TEXTDOMAIN),
		'array' => esc_html__('The :attribute must have at least :min items.', HF_TEXTDOMAIN),
	],
	'multiple_of' => esc_html__('The :attribute must be a multiple of :value.', HF_TEXTDOMAIN),
	'not_in' => esc_html__('The selected :attribute is invalid.', HF_TEXTDOMAIN),
	'not_regex' => esc_html__('The :attribute format is invalid.', HF_TEXTDOMAIN),
	'numeric' => esc_html__('The :attribute must be a number.', HF_TEXTDOMAIN),
	'password' => esc_html__('The password is incorrect.', HF_TEXTDOMAIN),
	'present' => esc_html__('The :attribute field must be present.', HF_TEXTDOMAIN),
	'prohibited' => esc_html__('The :attribute field is prohibited.', HF_TEXTDOMAIN),
	'prohibited_if' => esc_html__('The :attribute field is prohibited when :other is :value.', HF_TEXTDOMAIN),
	'prohibited_unless' => esc_html__('The :attribute field is prohibited unless :other is in :values.', HF_TEXTDOMAIN),
	'prohibits' => esc_html__('The :attribute field prohibits :other from being present.', HF_TEXTDOMAIN),
	'regex' => esc_html__('The :attribute format is invalid.', HF_TEXTDOMAIN),
	'required' => esc_html__('The :attribute field is required.', HF_TEXTDOMAIN),
	'required_array_keys' => esc_html__('The :attribute field must contain entries for: :values.', HF_TEXTDOMAIN),
	'required_if' => esc_html__('The :attribute field is required when :other is :value.', HF_TEXTDOMAIN),
	'required_unless' => esc_html__('The :attribute field is required unless :other is in :values.', HF_TEXTDOMAIN),
	'required_with' => esc_html__('The :attribute field is required when :values is present.', HF_TEXTDOMAIN),
	'required_with_all' => esc_html__('The :attribute field is required when :values are present.', HF_TEXTDOMAIN),
	'required_without' => esc_html__('The :attribute field is required when :values is not present.', HF_TEXTDOMAIN),
	'required_without_all' => esc_html__('The :attribute field is required when none of :values are present.', HF_TEXTDOMAIN),
	'same' => esc_html__('The :attribute and :other must match.', HF_TEXTDOMAIN),
	'size' => [
		'numeric' => esc_html__('The :attribute must be :size.', HF_TEXTDOMAIN),
		'file' => esc_html__('The :attribute must be :size kilobytes.', HF_TEXTDOMAIN),
		'string' => esc_html__('The :attribute must be :size characters.', HF_TEXTDOMAIN),
		'array' => esc_html__('The :attribute must contain :size items.', HF_TEXTDOMAIN),
	],
	'starts_with' => esc_html__('The :attribute must start with one of the following: :values.', HF_TEXTDOMAIN),
	'string' => esc_html__('The :attribute must be a string.', HF_TEXTDOMAIN),
	'timezone' => esc_html__('The :attribute must be a valid timezone.', HF_TEXTDOMAIN),
	'unique' => esc_html__('The :attribute has already been taken.', HF_TEXTDOMAIN),
	'uploaded' => esc_html__('The :attribute failed to upload.', HF_TEXTDOMAIN),
	'url' => esc_html__('The :attribute must be a valid URL.', HF_TEXTDOMAIN),
	'uuid' => esc_html__('The :attribute must be a valid UUID.', HF_TEXTDOMAIN),

	/*
	|--------------------------------------------------------------------------
	| Custom Validation Language Lines
	|--------------------------------------------------------------------------
	|
	| Here you may specify custom validation messages for attributes using the
	| convention "attribute.rule" to name the lines. This makes it quick to
	| specify a specific custom language line for a given attribute rule.
	|
	*/

	'custom' => [],

	/*
	|--------------------------------------------------------------------------
	| Custom Validation Attributes
	|--------------------------------------------------------------------------
	|
	| The following language lines are used to swap our attribute placeholder
	| with something more reader friendly such as "E-Mail Address" instead
	| of "email". This simply helps us make our message more expressive.
	|
	*/

	'attributes' => [],

];
