<?php

namespace Hello2Forms\Internals;

use CastToType;
use Hello2Forms\Architecture\Castable;

class CastHelper {
	/**
	 *
	 * @throws \Exception
	 */
	public static function cast( string $className, array $data, $dbSave = false ): array {
    $castedData = [];
    $object     = new $className();

    $model = $object->data;
    foreach ( $model as $key => $value ) {

        if ( ! array_key_exists( $key, $data ) ) {
            continue;
        }

        $type = explode( '|', $value )[0];

        $castedData[ $key ] = self::castToType( $data[ $key ], $type, $dbSave );
    }

    return $castedData;
}

private static function castToType( $value, string $type, bool $dbSave ) {
    switch ( $type ) {
        case 'json':
            return $dbSave ? json_encode( $value ) : json_decode( $value, true );
        case 'object':
            return $dbSave ? serialize( $value ) : unserialize( $value );
        case 'sanitize':
            return wp_generate_uuid4();
        default:
            return CastToType::cast( $value, $type );
    }
}

	public static function castArray( string $className, array $array, $dbSave = false ): array {
		$castedArray = [];
		foreach ( $array as $item ) {
			$castedArray[] = self::cast( $className, $item, $dbSave );
		}

		return $castedArray;
	}
}
