<?php

/**
 * Hello2Forms
 *
 * @package   Hello2Forms
 * @author    Infinite Consultancy LTD <contact@hello2.com>
 * @copyright 2024 Infinite Consultancy LTD
 * @license   GPL 2.0+
 * @link      https://hello2.com
 */

namespace Hello2Forms\Integrations;

use Hello2Forms\Engine\Base;

/**
 * Load custom template files
 */
class Template extends Base {

	/**
	 * Initialize the class.
	 *
	 * @return void
	 */
	public function initialize() : void {
		parent::initialize();

		// Override the template hierarchy for load /templates/content-demo.php
		\add_filter( 'template_include', array( self::class, 'load_content_demo' ) );
	}

	/**
	 * Example for override the template system on the frontend
	 *
	 * @param string $template The original templace HTML.
	 * @since 1.0.0
	 * @return string
	 */
	public static function load_content_demo( string $template ): string {
		global $wp_query;
		$theme_files = 'hello2forms/form.php';
		$exists_in_theme = locate_template($theme_files, false);

		if ( $wp_query->is_page('form') ) {
			if ( $exists_in_theme != '' ) {
				$template = $exists_in_theme;
			} else {
				$template = plugin_dir_path( __DIR__ ) . 'templates/form.php';
			}
		}

		return $template;
	}

}
