<?php

/**
 * @package   Hello2Forms
 * @author    Infinite Consultancy LTD <contact@hello2.com>
 * @copyright 2024 Infinite Consultancy LTD
 * @license   GPL 2.0+
 * @link      https://hello2.com
 *
 * Plugin Name:     Hello2 Forms
 * Plugin URI:      https://demo.hello2.com
 * Description:     Builder for Stylish & Smart Forms (Bookings, Marketing, Leads, Appointments) 
 * Version:         1.0.0
 * Author:          Infinite Consultancy LTD
 * Author URI:      https://hello2.com
 * Text Domain:     hello-forms
 * License:         GPL 2.0+
 * License URI:     http://www.gnu.org/licenses/gpl-3.0.txt
 * Domain Path:     /languages
 * Requires PHP:    8.0
 * WordPress-Plugin-Boilerplate-Powered: v3.3.0
 */

// If this file is called directly, abort.
use Hello2Forms\Backend\ActDeact;
use Hello2Forms\Backend\SettingsPage;
use Hello2Forms\Engine\Initialize;
use Micropackage\Requirements\Requirements;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'We\'re sorry, but you can not directly access this file.' );
}

define( 'HF_VERSION', '1.0.0' );
define( 'HF_TEXTDOMAIN', 'hello-forms' );
define( 'HF_NAME', 'Hello2 Forms' );
define( 'HF_PLUGIN_ROOT', plugin_dir_path( __FILE__ ) );
define( 'HF_PLUGIN_ABSOLUTE', __FILE__ );
define( 'HF_MIN_PHP_VERSION', '7.4' );
define( 'HF_WP_VERSION', '5.3' );

add_action(
	'init',
	static function () {
		load_plugin_textdomain( HF_TEXTDOMAIN, false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	}
);

if ( version_compare( PHP_VERSION, HF_MIN_PHP_VERSION, '<=' ) ) {
	add_action(
		'admin_init',
		static function () {
			deactivate_plugins( plugin_basename( __FILE__ ) );
		}
	);
	add_action(
		'admin_notices',
		static function () {
			echo wp_kses_post(
				sprintf(
					'<div class="notice notice-error"><p>%s</p></div>',
					__( '"Hello2 Forms" requires PHP ' . HF_MIN_PHP_VERSION . ' or newer.', HF_TEXTDOMAIN )
				)
			);
		}
	);

	// Return early to prevent loading the plugin.
	return;
}

$hello_forms_libraries = require HF_PLUGIN_ROOT . 'vendor/autoload.php'; //phpcs:ignore

require_once HF_PLUGIN_ROOT . 'utils/functions.php';
require_once HF_PLUGIN_ROOT . 'utils/isTimestamp.php';

$requirements = new Requirements(
	'Hello2 Forms',
	array(
		'php'            => HF_MIN_PHP_VERSION,
		'wp'             => HF_WP_VERSION
	)
);

if ( ! $requirements->satisfied() ) {
	$requirements->print_notice();

	return;
}

if ( ! wp_installing() ) {
	register_activation_hook( HF_TEXTDOMAIN . '/' . HF_TEXTDOMAIN . '.php', array( new ActDeact, 'activate' ) );
	register_deactivation_hook( HF_TEXTDOMAIN . '/' . HF_TEXTDOMAIN . '.php', array( new ActDeact, 'deactivate' ) );
	add_action('plugins_loaded',
		/**
		 * @throws Exception
		 */
		static function () use ( $hello_forms_libraries ) {
			// Backend only: Creates an url rewrite rule to load the settings page.
			SettingsPage::enqueueSettingsForPluginEmptyPage();

			new Initialize( $hello_forms_libraries );
		}
	);
}

