<?php

namespace Hello2Forms\Architecture;

trait DBUtils {
	protected \wpdb $db;
	private string $TABLE_PREFIX = 'hello2_forms_';

	public function __construct() {
		global $wpdb;
		$this->db = $wpdb;
	}

	public function maybeCreateTable( string $tableName, string $sql ): void {
		require_once ABSPATH.'/wp-admin/install-helper.php';
		maybe_create_table( $this->realTable( $tableName ), $this->realTable( $sql ) );
	}

	/**
	 * Returns the real table name with the user's WordPress instance prefix.
	 * This way we get autosuggestions from the PHPStorm.
	 * @param string $table
	 *
	 * @return string
	 */
	public function realTable( string $table ): string {
		if ($this->db->prefix === 'wp_') return $table;

		$replaceWordPressPrefixes = str_replace( 'wp_', $this->db->prefix, $table );

		return str_replace( ['wp_hello2_forms_'], $this->db->prefix . $this->TABLE_PREFIX, $replaceWordPressPrefixes );
	}

	public function getResults($sql, $mode = ARRAY_A) {
		return $this->db->get_results($this->realTable($sql), $mode);
	}

	public function insert(string $table, array $data, ?array $format = null) {
		return $this->db->insert($this->realTable($table), $data, $format);
	}
}
