<?php

namespace Hello2Forms\Architecture;

use Hello2Forms\Engine\Base;

abstract class AbstractApiController extends Base {
	protected string $resourceName;
	private string $namespace = 'hello2forms';
	protected string $version = '/v1/';

	public function __construct() {
		 $this->resourceName = substr(get_class($this), strrpos(get_class($this), '\\') + 1);

		add_action('rest_api_init', [$this, 'registerRoutes']);
	}

	abstract public function registerRoutes(): void;

	protected function registerRestRoute(string $route, array $args = [], bool $override = false) : bool {
		return register_rest_route( $this->namespace, $this->version . $this->resourceName . '/' .$route , $args, $override);
	}
}
